# python script to randomly generate root BMXs for buzz.
# by PEMDASI - http://pemdasi.net
# ------------------------------------------------------
import random
import time

def index_LoadFromFile(input_index):
	# Generate a datastructure representing the index.txt file
	# go line by line, if current line is a new directory
	# add it under the current directory and make the new
	# directory the current directory
	# if line is a /.. the directory is finished so we should
	# change the current directory to the parent directory.
	index = {}
	index_file = open(input_index, "r")
	index_array = index_file.readlines()
	index["root"] = []
	current_directory = "root"
	for line in index_array:
		line_current = line.strip()
		if line_current != "":
			if line_current[0] == "/":
				
				if line_current[1] != ".":
					#add new subdirectory
					current_directory = current_directory + line_current
					index[current_directory] = []
				if line_current[1] == ".":
					current_directory = index_GetParentDirectory(current_directory)
			if line_current[0] != "/" and line_current[len(line_current)-1] != "-":
				index[current_directory].append(line_current)
	return index

def index_GetParentDirectory(directory):
	# function to take a string representing a directory and returning the
	# parent directory
	directory_array = directory.split("/")
	parent_array = directory_array[:len(directory_array)-1]
	parent = "root"
	for item in parent_array:
		if item == "root":
			parent = "root"
		if item != "root":
			parent = parent + "/" + item 
	return parent
		

def ruleset_LoadFromFile(input_ruleset):
	ruleset = []
	ruleset_array = open(input_ruleset, "r").readlines()
	for rule in ruleset_array:
		rule_params = rule.split(",", 1)
		rule_params_number = rule_params[0]
		rule_params_directories = rule_params[1].split(",")
		if len(rule_params[1].split(",")) == 0:
			print "only one directory!"
			rule_params_directories = [rule_params_directories, ]
		ruleset.append([rule_params_number, rule_params_directories])
	return ruleset

def machines_SelectFromRuleset(ruleset, index):
	files = []
	for rule in ruleset:
		files_from_rule = machines_SelectFromRule(rule, index)
		#print rule, files_from_rule
		for file in files_from_rule:
			files.append(file)
	
	return files

def machines_SelectFromRule(rule, index):
	number_of_files = rule[0]
	available_files = []
	#print "From ",
	for directory_us in rule[1]:
		directory = directory_us.strip()
		if directory != "end":
			# print directory
			for machine in index[directory]:
				available_files.append(machine)
	random.seed(time.time())
	random.shuffle(available_files)
	selected_files = available_files[:int(number_of_files)]
	#print "     ",
	#print selected_files
	return selected_files

input_index = "index.txt"
input_ruleset = "ruleset.txt"

print "Loading " + input_index + "...", 
index = index_LoadFromFile(input_index)
print "done."

print "loading " + input_ruleset + "...",
ruleset = ruleset_LoadFromFile(input_ruleset)
print "done."

print "Selecting machines based on ruleset...", 
machines = machines_SelectFromRuleset(ruleset, index)
print "done!"
print ""
print "--------------------------------------------"
print "Generated machine list: "
for machine in machines:
	print "     " + machine
