## Template for a functioning pydrum sequence and example bmx
## Questions comments: look to buzzchurch forum or email at dukajoe@yahoo.com


from pydrumlib import *

bass = drumtrack()
bass.setarge('SGridBETA', 'Trigger 0')
bass.fillblank(2)
snare = drumtrack()
snare.setarge('SGridBETA', 'Trigger 1')
snare.fillblank(2)
hat = drumtrack()
hat.setarge('SGridBETA', 'Trigger 2')
hat.fillblank(2)
crash = drumtrack()
crash.setarge('SGridBETA', 'Trigger 3')
crash.fillblank(0)
tomone = drumtrack()
tomone.setarge('SGridBETA', 'Trigger 4')
tomone.fillblank(0)
tomtwo = drumtrack()
tomtwo.setarge('SGridBETA', 'Trigger 5')
tomtwo.fillblank(0)

snareauxdef1 = ['Freeverb', 'Rev Out', 'Orange Filter', 'Cutoff']
bassauxdef1 = ['Delay', 'Wet Out', 'Pampurfe', 'Gain']
hatauxdef1 = ['Flasbox', 'Wet/Dry', 'Orange Filter2', 'Cutoff']

basstrack1 = [40, 0, 3, 0, 3, 0, 3, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0]
hattrack1 = [0]

basstrack2 = [0, 7, 0, 0, 6]
snaretrack1 = [2, 0, 1]

hattrack2 = [0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0]
hataux1 = [127, -15, 100, 90, 80, 70, 60, -20, 70, 80, 90, 100, 110, 120, 127, -1000, 240, -63, -1000]
basstrack3 = [0, 1, 0, 7, 0, 7, 0, 7]
snaretrack2 = [4, 0, 3, 0, 2, 0, 3]
snareaux1 = [0, -31, 100, -31, 60, -31, -1000, 240, -15, 40, -3, 50, -3, 60, -3, 70, -3, 80, -15, 100, -15, -1000]

basstrack4 = [0, 1, 0, 3, 0, 3, 0, 4, 0]  ##[1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1]
snaretrack3 = [4, 0, 2, 0, 1, 0, 2, 0, 3] ##[0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0]
tomonetrack1 = [6, 0, 7, 0, 1]
tomtwotrack1 = [7, 0, 1, 0, 1, 0, 0, 3]
hataux2 = [127, -1000, 240, -1000]
snareaux2 = [0, -1000, 240, -1000]

basstrack5 = [0, 3, 0, 3]
snaretrack4 = [1, 0, 1, 0, 2, 0, 1]

crashtrack1 = [0]


def OnMidiNote(channel,value,velocity):
    print "[MIDINote] channel: %3i value: %3i velocity: %3i" % (channel,value,velocity)



    ##Intro
    if (value == 52 and velocity != 0):
        bass.changetrack(basstrack1, 1, 0)
        hat.changetrack(hattrack1, 2, 0)

    ##Main
    if (value == 53 and velocity != 0):
        bass.changetrack(basstrack2, 2, 0)
        snare.changetrack(snaretrack1, 2, 0)

    if (value == 54 and velocity != 0):
        hat.changetrack(hattrack2, 1, 0)
        hat.changeaux(hatauxdef1, hataux1)
        bass.changetrack(basstrack3, 1, 0)
        snare.changetrack(snaretrack2, 1, 0)
        snare.changeaux(snareauxdef1, snareaux1)
        
    if (value == 55 and velocity != 0):
        hat.changetrack(hattrack1, 2, 1)
        hat.changeaux(hatauxdef1, hataux2)
        hat.auxloopswitch(0)
        bass.changetrack(basstrack4, 1, 1)
        snare.changetrack(snaretrack3, 1, 1)
        snare.changeaux(snareauxdef1, snareaux2)
        snare.auxloopswitch(0)

    if (value == 56 and velocity != 0):
        tomone.changetrack(tomonetrack1, 1, 0)
        tomone.trkloopswitch(0)
        tomtwo.changetrack(tomtwotrack1, 1, 0)
        tomtwo.trkloopswitch(0)

    if (value == 64 and velocity != 0):
        bass.changetrack(basstrack5, 1, 1)
        snare.changetrack(snaretrack4, 1, 1)

    if (value == 65 and velocity != 0):
        bass.trackswitch(0)

    if (value == 66 and velocity != 0):
        crash.changetrack(crashtrack1, 1, 0)
        crash.trkloopswitch(0)
        snare.trackswitch(0)
        bass.trackswitch(0)
        hat.trackswitch(0)
        tomone.trackswitch(0)
        tomtwo.trackswitch(0)

def OnTick():
    bass.onbeat()
    snare.onbeat()
    hat.onbeat()
    crash.onbeat()
    tomone.onbeat()
    tomtwo.onbeat()

SetEventTarget("OnMidiNote", OnMidiNote)
SetEventTarget("OnTick", OnTick)



        

