# pydrumlib.py  v 0.1
# Library for automated live drumtracks usage in buzz
# Copyright 2007
# by Michael Collins, aka dukajoe
# Questions comments: look to buzzchurch forum or email at dukajoe@yahoo.com

from buzz import *


peerind = -1
drumind = []
z = 0


def peerctrlhandler(drumoraux, returnmode, pid, chgswi): ## 1 = drum 0 = aux, 1 = assignment, 0 = onbeat
    global peerind                                       ## also, changeswitch for aux
    global drumind
    global z
##    print 'drumind: ',drumind
##    print 'z: ',z
    if returnmode:
        if drumoraux:
            peerind += 1
            drumind.append(peerind)
        else:
            if chgswi:
                z += 1
                ClearPeerCtrlTarget(drumind[pid]+z)
                return drumind[pid]+z
            else:
                peerind += 1
        return peerind
    else:
##        print drumind
##        print pid
        return drumind[pid]
    
    


class drumtrack:
    def __init__(self):
        self.id = len(drumind)
        self.trackend = 0
        self.drumctr = 1
        self.trigger = 254
        self.seqmap=[]
        self.sequence=[]
        self.paramname = ""
        self.machname = ""
        self.curtick = 0
        self.lenmult = 1
        self.auxcount = 0
        self.auxtrack = []
        self.auxtick = []
        self.stopseq = []
        self.stoptrack = []
        self.auxmute = []
        self.trackmute = 0
        self.auxloop = []
        self.trackloop = 1
        self.chgauxswitch = 0
        self.trackrupt = 0
        self.newtrackdef = []
        self.chgtrkswitch = 0
        self.trackrupt = 0
##        print 'track id: ',self.id
        

    def setarge(self, machname, paramname):
        
        k = 0
        self.machname = machname
        self.paramname = paramname
        tempmach = GetMachine(self.machname)
        surname = UnpackMachineInfo(GetMachineInfo(tempmach))
        x = surname[5]+surname[6]
        for i in range(x):
            if surname[7][i][1] == self.paramname:
                k = i
        if k > surname[5]:
            group = 2
        else:
            group = 1
        SetPeerCtrlTarget(peerctrlhandler(self.drumctr, 1, self.id, self.chgauxswitch),tempmach,group,k)


    def createtrack(self, seqmap, lenmult, trigger):
        self.trigger = trigger
        self.seqmap = seqmap
        self.lenmult = lenmult
        foundlength, i, k, t, p, m = 0, 0, 0, 0, 0, 0
        for m in range(len(self.seqmap)):
            if self.seqmap[m] == 0:
                foundlength += 1
            else:
                foundlength += self.seqmap[m]
        self.sequence = [0] * (foundlength * self.lenmult)
        for i in range(len(self.seqmap)):
            if not self.seqmap[i]:
                self.sequence[t] = 1
                t += 1
                t += (self.lenmult - 1)
            else:
                for k in range(self.seqmap[i]*self.lenmult):
                    t += 1


    def onbeat(self):
        i, p = 0, 0
        self.chgtrk()
        self.chgaux()
        self.trackend = 0
##        Track Controls
        if not self.trackmute:
            if self.sequence[self.curtick]:
                SendPeerCtrlChange(peerctrlhandler(1, 0, self.id, 0), 0, self.trigger)
            self.curtick += 1
            if (self.curtick == len(self.sequence)):
                self.curtick = 0
                self.trackend = 1
                if not self.trackloop:
##                    print 'did this work?'
                    self.trackmute = 1
##        Auxilary Controls
        for i in range(self.auxcount):
            if not self.auxmute[i]:
                if self.auxtrack[(self.stoptrack[i] + self.auxtick[i])] >= 0:
##                    print 'Auxtrack Val: %3s   Auxtrack: %s' % (self.auxtrack[self.auxtick[i] + self.stoptrack[i]], i+1)
                    SendPeerCtrlChange((peerctrlhandler(0, 0, self.id, 0)+(i+1)), 0, self.auxtrack[self.auxtick[i] + self.stoptrack[i]])
                    self.auxtick[i] += 1
                    if self.auxtick[i] >= (self.stoptrack[i+1] - self.stoptrack[i]): 
                        self.auxtick[i] = 0
                        if not self.auxloop[i]:
                            self.auxmute[i] = 1
                else:
                    self.auxtick[i] += 1
##                    print 'Auxtrack Val: rest   Auxtrack: %s' % (i+1)
                    if self.auxtick[i] >= (self.stoptrack[i+1] - self.stoptrack[i]):
                        self.auxtick[i] = 0
                        if not self.auxloop[i]:
                            self.auxmute[i] = 1
##        print '----------------------------------------------------------------'
        

    def auxdef(self, auxtarg):
        global z
        self.auxcount = (len(auxtarg) / 2)
        i = 0
        m = 0
        self.drumctr = 0
        for i in range(self.auxcount):
            self.setarge(auxtarg[m], auxtarg[m+1])
            m += 2
        z = 0
        self.auxtick = [0] * self.auxcount
        self.auxloop = [1] * self.auxcount
        self.auxmute = [0] * self.auxcount


    def auxfill(self, auxcmd):    ##Must auxdef before auxfill
        i, p, l, o, t, m, n = 0, 0, 0, 0, 0, 0, 0
        r = -1
        self.stopseq = [0] * (self.auxcount + 1)
        self.stoptrack = [0] * (self.auxcount + 1)
        for i in range(len(auxcmd)):
            if auxcmd[i] == -1000:
                m += 1
                t += 1
                r += 1
                self.stopseq[m] = (i-r)
                self.stoptrack[t] = self.stopseq[m]
                self.stopseq[m] = (i-r)
                p, l = 0, 0
                for p in range(self.stopseq[m] - self.stopseq[m-1]):
##                    print 'main fill range: ',self.stopseq[m] - self.stopseq[m-1]
##                    print 'neg condition:',auxcmd[p + r + self.stopseq[m-1]]
                    if auxcmd[p + r + self.stopseq[m-1]] >= 0:
                        self.auxtrack.append(auxcmd[r + p + self.stopseq[m-1]])
                    else:
                        o = 0
##                        print 'rest range: ',auxcmd[(p + r + self.stopseq[m-1])] * -1
                        for o in range(auxcmd[(p + r + self.stopseq[m-1])] * -1):
                            self.auxtrack.append(-1)
                            l += 1
                        l -= 1
##                    print 'current track: ',self.auxtrack
                n += l
                self.stoptrack[t] += n
        


##If you mute a track or aux, it will resume from the same spot, rather than just
##muting and resuming to play--perhaps not the most desireable behavior                

    def trkloopswitch(self, a): ## 1 = turn track loop on, 0 = turn track loop off
        if a:
            self.trackloop = 1
        else:
            self.trackloop = 0


    def trackswitch(self, a): ## 1 = turn track on, 0 = turn track off
        if a:
            self.trackmute = 0
        else:
            self.trackmute = 1

##If you want to loop or mute an individual auxtrack, just set the specific
##variable equal to the value (1 or 0)

    def auxswitch(self, a): ## 1 = turn aux on, 0 = turn aux off
        if a:
            for i in self.auxmute:
                self.auxmute[i] = 0
        else:
            for i in self.auxmute:
                self.auxmute[i] = 1


    def auxloopswitch(self, a): ## 1 = turn auxloop on, 0 = turn auxloop off
        if a:
            for i in self.auxloop:
                self.auxloop[i] = 1
        else:
            for i in self.auxloop:
                self.auxloop[i] = 0


    def changetrack(self, newtrackdef, lenmult, trackrupt):
        self.newtrackdef = newtrackdef
        self.newlenmult = lenmult
        self.trackrupt = trackrupt
        self.chgtrkswitch = 1
        

    def chgtrk(self):
        if self.chgtrkswitch:
##            print self.trackmute
##            print self.trackend
            if self.trackrupt:
                self.createtrack(self.newtrackdef, self.newlenmult, self.trigger)
                self.curtick = 0
                self.trackswitch(1)
                self.chgtrkswitch = 0
            else:
                if (self.trackend or self.trackmute):
                    self.createtrack(self.newtrackdef, self.newlenmult, self.trigger)
                    self.curtick = 0
                    self.trackswitch(1)
##                    print 'track: changed without interrupt'
                    self.chgtrkswitch = 0
        else:
            return

        
    def queuemode(self, b):     ## Globally sets interupt mode, such that 1 will queue
        if b == 1:              ## track and will not interupt for tracks
            self.trackrupt = 0  ## actually, doesn't currently work
        if b == 0:
            self.trackrupt = 1

         
    def changeaux(self, newauxdef, newauxcmd):
        self.newauxdef = newauxdef
        self.newauxcmd = newauxcmd
        self.chgauxswitch = 1


    def chgaux(self):
        if self.chgauxswitch:
            self.auxtrack = []
            self.auxdef(self.newauxdef)
            self.auxfill(self.newauxcmd)
            for i in self.auxtick:
                self.auxtick[i] = 0
            self.auxswitch(1)
            self.chgauxswitch = 0
##            print 'aux: changed'
        else:
            return

    def fillblank(self, numauxes):
        self.trackswitch(0)
        for i in range(numauxes):
            peerctrlhandler(0, 1, self.id, 0)

        
        









        
